document.addEventListener('DOMContentLoaded', function() {
  const menuToggle = document.getElementById('menuToggle');
  const wrapper = document.getElementById('wrapper');
  const sidebarOverlay = document.getElementById('sidebarOverlay');

  function toggleMenu() {
    wrapper.classList.toggle('toggled');
  }

  menuToggle.addEventListener('click', function(e) {
    e.preventDefault();
    toggleMenu();
  });

  sidebarOverlay.addEventListener('click', function() {
    if (window.innerWidth <= 768) {
      toggleMenu();
    }
  });

  if (window.innerWidth <= 768) {
    wrapper.classList.remove('toggled');
  }
});

// Partículas
particlesJS("particles-js", {
  particles: {
    number: { value: 80, density: { enable: true, value_area: 800 } },
    color: { value: "#00ffff" },
    shape: {
      type: "circle",
      stroke: { width: 0 },
      polygon: { nb_sides: 5 }
    },
    opacity: { value: 0.5 },
    size: { value: 3, random: true },
    line_linked: {
      enable: true,
      distance: 150,
      color: "#00ffff",
      opacity: 0.4,
      width: 1
    },
    move: {
      enable: true,
      speed: 2,
      direction: "none",
      out_mode: "out"
    }
  },
  interactivity: {
    detect_on: "canvas",
    events: {
      onhover: { enable: true, mode: "repulse" },
      onclick: { enable: true, mode: "push" }
    },
    modes: {
      repulse: { distance: 100, duration: 0.4 },
      push: { particles_nb: 4 }
    }
  },
  retina_detect: true
});
